package com.junkprojects.comm.rpc.example;

import java.io.*;
import java.net.*;

import com.junkprojects.comm.rpc.*;

public class RPCTestServerThread extends Thread {

  Socket _csock = null;

  public RPCTestServerThread(Socket csock) {

    _csock = csock;
    start();

  }

  public void run() {

    RPCInputStream rpcis = null;
    RPCOutputStream rpcos = null;
    RPCMessage message = null;
    RPCCallMessage cmessage = null;
    RPCAcceptedReplyMessage armessage = null;
    RPCRejectedReplyMessage rrmessage = null;
    String replystring = null;

    replystring = new String("Right back at ya!");

    try {
      rpcis = new RPCInputStream(_csock.getInputStream());
      rpcos = new RPCOutputStream(_csock.getOutputStream());
    } catch (IOException ioe) {
      printConnectionInfo();
      ioe.printStackTrace();
      stop();
    }

    try {
      message = rpcis.readMessage();
      printConnectionInfo();
      if(message instanceof RPCCallMessage) {
        cmessage = (RPCCallMessage) message;
        System.out.println(cmessage.toString());
        if (cmessage.getProcedureNumber() == 305) {
          armessage = new RPCAcceptedReplyMessage(cmessage.getTransactionId(),
                                                 new RPCNullAuthentication(),
                                                 replystring.getBytes());
          rpcos.writeMessage(armessage);
        }
        else if (cmessage.getProcedureNumber() == 306) {
          armessage = new RPCAcceptedReplyMessage(cmessage.getTransactionId(),
                                                 new RPCNullAuthentication(),
                                                 100,
                                                 305);
          rpcos.writeMessage(armessage);
        }
        else if (cmessage.getProcedureNumber() == 307) {
          rrmessage = new RPCRejectedReplyMessage(cmessage.getTransactionId(),
                                                  2,
                                                  5);
          rpcos.writeMessage(rrmessage);
        }
        else if (cmessage.getProcedureNumber() == 308) {
          try {
            rrmessage = new RPCRejectedReplyMessage(cmessage.getTransactionId(),
                                           RPCRejectedReplyMessage.AUTH_FAILED);
            rpcos.writeMessage(rrmessage);
          } catch (RPCMessageException rpcme) {
            System.out.println("Could not create Auth Rejected Message");
            rpcme.printStackTrace();
            stop();
          }
        }
        else 
          System.out.println("Dont know procedure number "+
                             cmessage.getProcedureNumber()+".");
 

      }
      else {
        System.out.println("Can not determin message type.");
      }
    } catch (RPCIOException rpcioe) {
      printConnectionInfo();
      rpcioe.printStackTrace();
      stop();
    } catch (IOException ioe) {
      printConnectionInfo();
      ioe.printStackTrace();
      stop();
    } catch (ClassCastException cce) {
      printConnectionInfo();
      cce.printStackTrace();
      stop();
    }
   
  }

  public void printConnectionInfo() {
    System.out.println("On connection from host "+
                       _csock.getInetAddress().toString()+
                       ".");                       
 
  }


}
