package com.junkprojects.comm.rpc.example;

import java.io.*;
import java.net.*;

import com.junkprojects.comm.rpc.*;

public class RPCTestServer {


  public RPCTestServer(int port) {

    ServerSocket ssock = null;
    Socket csock = null;
    RPCTestServerThread rpcservthrd = null;
    InetAddress localaddr = null;

    try {
      localaddr = InetAddress.getLocalHost();
      System.out.println("Starting RPC server on "+localaddr);
    } catch (UnknownHostException uhe) {
      uhe.printStackTrace();
      System.exit(-1);
    }

    try {
      ssock = new ServerSocket(port,10,localaddr);
    } catch (IOException ioe) {
      ioe.printStackTrace();
      System.exit(-1);
    }

    while(true) {

       try {
         csock = ssock.accept();
         rpcservthrd = new RPCTestServerThread(csock);
       } catch (IOException ioe) {
         ioe.printStackTrace();
       }

    }
    

  }

  public static void usage() {
    System.out.println("RPCTestServer port");
  }

  public static void main(String argv[]) {

    int port = 0;
    RPCTestServer rpcserver = null;

    if (argv.length < 1) {
      usage();
      System.exit(-1);
    }

    try {
      port = Integer.parseInt(argv[0]); 
    } catch (NumberFormatException nfe) {
      usage();
      System.exit(-1);
    }

    rpcserver = new RPCTestServer(port);

  }

}
