package com.junkprojects.comm.rpc.example;

import java.net.*;
import java.io.*;

import com.junkprojects.comm.rpc.*;

public class RPCTestClient extends Object {

  protected static String TYPE_PASS = "pass";
  protected static String TYPE_FAIL = "fail";
  protected static String TYPE_RJT  = "reject";
  protected static String TYPE_AUTHFAIL = "authfail";


  public RPCTestClient(String host,
                       int    port,
                       String type) 
  {

     Socket sock = null;
     RPCInputStream rpcis = null;
     RPCOutputStream rpcos = null;
     RPCCallMessage cmessage = null;
     RPCAcceptedReplyMessage armessage = null;
     RPCRejectedReplyMessage rrmessage = null;
     RPCReplyMessage rmessage = null;
     RPCMessage message = null;
     boolean closesock = false;
     int procedure = -1;

     System.out.println("Trying to connect to "+host+" on port "+port+".");

     try {
       sock = new Socket(host,port);
     } catch (UnknownHostException uhe) {
       uhe.printStackTrace();
       System.exit(-1);
     } catch (IOException ioe) {
       ioe.printStackTrace();
       System.exit(-1);
     }

     try{
       rpcis = new RPCInputStream(sock.getInputStream());
       rpcos = new RPCOutputStream(sock.getOutputStream());
     } catch (IOException ioe) {
       ioe.printStackTrace();
         try {
           sock.close();
         } catch (IOException ioe2) {
           ioe2.printStackTrace();
         }
       System.exit(-1);
     }

     if (type.equals(RPCTestClient.TYPE_PASS))
       procedure = 305;
     else if (type.equals(RPCTestClient.TYPE_FAIL))
       procedure = 306;
     else if (type.equals(RPCTestClient.TYPE_RJT))
       procedure = 307;
     else if (type.equals(RPCTestClient.TYPE_AUTHFAIL))
       procedure = 308;
     else {
       System.out.println("Type is not pass of fail, going for pass");
       procedure = 305;
     } 
      
     cmessage = new RPCCallMessage();
     cmessage.setProgramNumber(666);
     cmessage.setProgramVersion(24);
     cmessage.setProcedureNumber(procedure);
     cmessage.setCredentails(new RPCNullAuthentication());
     cmessage.setVerifier(new RPCNullAuthentication());     
     cmessage.setParamaters(new String("This be the params dood").getBytes());

     try {
       rpcos.writeMessage(cmessage);
       message = rpcis.readMessage();
 
       if (message instanceof RPCAcceptedReplyMessage) {
         armessage = (RPCAcceptedReplyMessage) message; 
         System.out.println(armessage.toString());
       }
       else if (message instanceof RPCRejectedReplyMessage) {
         rrmessage = (RPCRejectedReplyMessage) message;
         System.out.println(rrmessage.toString());
       }
       else
         System.out.println("Got a reply of an unknown type!");
     } catch (IOException ioe) {
       ioe.printStackTrace();
       closesock = true;
     } catch (RPCIOException rpcioe) {
       rpcioe.printStackTrace();
       closesock = true;
     } finally {
       if (closesock) {
         try {
           sock.close();
         } catch (IOException ioe2) {
           ioe2.printStackTrace();
         }
         System.exit(-1);
       }
     }



  }

  public static void usage() {
    System.out.println("RPCTestClient host port pass/fail/reject/authfail");
  }

  public static void main(String argv[]) {

    RPCTestClient client = null;
    String host = null,
           port = null,
           type = null;
    int porti = 0;

    if (argv.length < 3) {
      usage();
      System.exit(-1);
    }

    host = argv[0];

    if (!((argv[2].toLowerCase().equals("pass")) ||
          (argv[2].toLowerCase().equals("fail")) ||
          (argv[2].toLowerCase().equals("reject")) ||
          (argv[2].toLowerCase().equals("authfail")))) {
     usage();
     System.exit(-1);
    }
    type = argv[2].toLowerCase();

    port = argv[1];
    try {
      porti = Integer.parseInt(port);
    } catch (NumberFormatException nfe) {
      usage();
      System.exit(-1);
    }

    client = new RPCTestClient(host,porti,type);

  }

}

