package com.junkprojects.comm.rpc;

import java.io.*;


public class RPCInputStream extends DataInputStream {

  InputStream _basestream = null;

  public RPCInputStream(InputStream is) {

    super(is);
    _basestream = is;

  }

  public RPCMessage readMessage() 
         throws IOException,
                RPCIOException
  {

    int framelength = 0,
        xid         = 0,
        msgtype     = 0;
    RPCMessage message = null;

    framelength = readInt();
    xid = readInt();
    msgtype = readInt();
    if (msgtype == message.MSGTYPE_CALL) {
      message = readCallMessage(xid,framelength);
      return (message);
    }
    else if (msgtype == RPCMessage.MSGTYPE_REPLY) {
      message = readReplyMessage(xid,framelength);
      return (message);
    }
    else
      throw new RPCIOException("Unknow message type of "+msgtype+".");
    

  }

  private RPCCallMessage readCallMessage(int xid,
                                        int framelength)        
         throws IOException,
                RPCIOException
  {

   
    int clength     = 0,
        authflavor  = 0,
        rpcversion  = 0;
    RPCCallMessage cmessage = null;
    RPCAuthentication creds,
                      verifier = null;
    byte[] sink = null;

    cmessage = new RPCCallMessage();

    cmessage.setTransactionId(xid);
      
    rpcversion = readInt();
    if (rpcversion != 2) {
      drain(framelength,6); 
      throw new RPCIOException("RPC version was not 2, value "+
                              "is rpcversion, for trasaction "+
                              cmessage.getTransactionId()+".");
    }
    cmessage.setProgramNumber(readInt());
    cmessage.setProgramVersion(readInt());
    cmessage.setProcedureNumber(readInt());
   
    authflavor = readInt();
    
    if (authflavor == 0)  
      creds = new RPCNullAuthentication();

    clength = cmessage.getLength();
    clength = framelength - clength;

    if (clength <= 0) {
      throw new RPCIOException("Frame length is not "+
                               "valid. Frame length is "+framelength+
                               " param length is "+clength);
    } 

    sink = new byte[clength];
    read(sink);

    cmessage.setParamaters(sink);

    return cmessage;

  }

  private RPCReplyMessage readReplyMessage(int xid,
                                           int framelength)
          throws IOException,
                 RPCIOException
  {

    int rplystat = 0;
    RPCReplyMessage rmessage = null;

    rplystat = readInt();
    if (rplystat == RPCReplyMessage.RPLY_ACCEPTED) 
      rmessage = readAcceptedReply(xid,framelength);
    else if (rplystat == RPCReplyMessage.RPLY_DENIED)
      rmessage = readRejectedReplyMessage(xid,framelength);
    else
      throw new RPCIOException ("Reply message type is invalid. Value "+
                                "is "+rplystat+".");

    return rmessage;

  }

  private RPCAcceptedReplyMessage readAcceptedReply(int xid,
						    int framelength) 
          throws IOException,
                 RPCIOException
  {

     int acceptstat = 0,
         authflavor = 0,
         clength = 0,
         lowprognumb = 0,
         highprognumb = 0;
     byte[] params = null;
     RPCAuthentication verifier = null;
     RPCAcceptedReplyMessage armessage = null;
 
     authflavor = readInt();
     if (authflavor == 0)
       verifier = new RPCNullAuthentication();

     acceptstat = readInt();

     armessage = new RPCAcceptedReplyMessage(xid,verifier,null);

     if (acceptstat == RPCAcceptedReplyMessage.ACCPT_SUCCESS) {
       clength = framelength - armessage.getLength();
       params = new byte[clength];

       read(params);

       armessage.setParamaters(params);
       return(armessage);
     }
     else if (acceptstat == RPCAcceptedReplyMessage.ACCPT_PROG_MISMATCH) {
    
       lowprognumb = readInt();
       highprognumb = readInt();

       armessage = new RPCAcceptedReplyMessage(xid,verifier,
                                               lowprognumb,highprognumb);
       return(armessage);
     }
     else if ((acceptstat == RPCAcceptedReplyMessage.ACCPT_PROG_UNAVAIL) ||
              (acceptstat == RPCAcceptedReplyMessage.ACCPT_PROC_UNAVAIL) ||
              (acceptstat == RPCAcceptedReplyMessage.ACCPT_GARBAGE_ARGS) || 
              (acceptstat == RPCAcceptedReplyMessage.ACCPT_SYS_ERR))
     {
       try {
         armessage = new RPCAcceptedReplyMessage(xid,verifier,acceptstat);
         return(armessage);
       } catch (RPCMessageException rpcme) {
         //This should never happen, if it does there is a flaw
         //in the code -PICKARD
         throw new RPCIOException("Could not create Accepted Message "+
                                  "due to an error. Error is "+
                                  rpcme.toString());
       }
     }
     else {
       throw new RPCIOException("Accepted Reply Message has unknown "+
                                "status of "+acceptstat+".");
     }

  } 

  private RPCRejectedReplyMessage readRejectedReplyMessage(int xid,
					                   int framelength)
          throws RPCIOException,
                 IOException
  {

    int rejectstat = 0,
        lowrpcnumb = 0,
        highrpcnumb = 0,
        authstat = 0,
        authcode = 0,
        authflavor = 0;
    RPCRejectedReplyMessage rrmessage = null;
    RPCAuthentication verifier = null;

    rejectstat = readInt();

    if (rejectstat == RPCRejectedReplyMessage.RJT_RPC_MISMATCH) {
      lowrpcnumb = readInt();
      highrpcnumb = readInt();
    
      rrmessage = new RPCRejectedReplyMessage(xid, lowrpcnumb,highrpcnumb);
      return (rrmessage);
    
    }
    else if (rejectstat == RPCRejectedReplyMessage.RJT_AUTH_ERROR) {
       authcode = readInt();

       try {
         rrmessage = new RPCRejectedReplyMessage(xid,authcode);
         return(rrmessage);
       } catch (RPCMessageException rpcme) {
         //This should never happen, if it does there is a flaw
         //in the code -PICKARD
         throw new RPCIOException("Could not create Accepted Message "+
                                  "due to an error. Error is "+
                                  rpcme.toString());
       }


    }
    else {
      throw new RPCIOException("Rejected Reply Message has unkown "+
                               "status of "+rejectstat+".");
    } 
     

  }
  
  private void drain(int framelength,
                     int offset) 
          throws IOException
  {
    //Drains the Stream for the next message -PICKARD

    byte[] sink = null;

    sink = new byte[framelength-offset];
    read(sink);
    sink = null;

  }


  private int getRecordLength() 
          throws IOException
  {

    int frameheader = 0;

    frameheader = readInt();
 
    //Droping the multiple frame boolean, 
    //its outside the scope of this impl -PICKARD

    frameheader = frameheader << 1;

    return frameheader;

  }

}
