package com.junkprojects.comm.rpc;

public class RPCAcceptedReplyMessage extends RPCReplyMessage {

  protected static int ACCPT_SUCCESS       = 0;
  protected static int ACCPT_PROG_UNAVAIL  = 1;
  protected static int ACCPT_PROG_MISMATCH = 2;
  protected static int ACCPT_PROC_UNAVAIL  = 3;
  protected static int ACCPT_GARBAGE_ARGS  = 4;
  protected static int ACCPT_SYS_ERR       = 5;

  RPCAuthentication _verifier = null;
  byte[] _procparams          = null;
  int _lowprognumb, 
      _highprognumb           = 0;

  int _accepttype = -1;

  public RPCAcceptedReplyMessage(int xid,
                                 RPCAuthentication verifier,
                                 byte[] procparams)
  {

     super();

    _accepttype = ACCPT_SUCCESS;
    _replymessagetype = RPLY_ACCEPTED;

    _xid = xid;
    _verifier = verifier;
    _procparams = procparams;


  }

  public RPCAcceptedReplyMessage(int xid,
                                 RPCAuthentication verifier,
                                 int lowprognumb,
                                 int highprognumb)
  {

    super();

    _accepttype = ACCPT_PROG_MISMATCH;
    _replymessagetype = RPLY_ACCEPTED;

    _xid = xid;
    _verifier = verifier;
    _lowprognumb = lowprognumb;
    _highprognumb = highprognumb;


  }

  public RPCAcceptedReplyMessage(int xid,
                                 RPCAuthentication verifier,
                                 int accepttype) 
         throws RPCMessageException
  {

     super();

     if((accepttype != ACCPT_PROG_UNAVAIL) ||
        (accepttype != ACCPT_PROC_UNAVAIL) ||
        (accepttype != ACCPT_GARBAGE_ARGS) ||
        (accepttype != ACCPT_SYS_ERR))
     { 
       throw new RPCMessageException("Invalid accept message type "+
                                     accepttype+".");
     }

     _accepttype = accepttype;
     _replymessagetype = RPLY_ACCEPTED;

  }

  public int getLength() {

    int len = 0;

    len = 16; //The already gotten header info -PICKARD

    if (_verifier != null) {
      len = len + 1;
      if(_verifier.getRawParams() != null)
        len = _verifier.getRawParams().length;
    }

    if(_accepttype == ACCPT_SUCCESS) {

      if (_procparams != null)
        len = len + _procparams.length; 

      return (len);  
    }

    else if (_accepttype == ACCPT_PROG_MISMATCH) {

      len = len + 8;
      return (len);

    }

    else 
      return (len);
  
  }

  public int getAcceptedReplyMessageType() {
    return _accepttype;
  }

  public int getProgramLowVersion() {
    return _lowprognumb;
  }

  public int getProgramHighVersion() {
    return _highprognumb;
  }

  public byte[] getParamaters() {
    return _procparams;
  }

  public RPCAuthentication getVerifier() {
    return _verifier;
  }

  public void setParamaters(byte[] procparams) {
    _procparams = procparams;
  }

  public String toString() {

    if (_accepttype == ACCPT_SUCCESS)
      return new String("Transaction id -> "+_xid+"\n"+
                        "Accept type -> "+_accepttype+"\n"+
                        "Params -> "+new String(_procparams));
    else 
      return new String("Transaction id -> "+_xid+"\n"+
                        "Accept type -> "+_accepttype+"\n"+
                        "Low Program numb -> "+_lowprognumb+"\n"+
                        "High Program numb -> "+_highprognumb);
  }




}
